/*
 * Decompiled with CFR 0.152.
 */
package emulator.sidplay;

import emulator.analyzer.sid.SidImage;
import emulator.analyzer.sid.SidProcessor;
import emulator.assembler.SymbolTable;
import emulator.hardware.memory.MemoryBlock;
import emulator.util.ByteArrayWrapper;
import emulator.util.file.FileHelper;
import emulator.util.file.FileInfo;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SidPlayPrg {
    private int start_address = 0;
    private byte[] prg_data = null;
    private int init_vector = -1;
    private int exec_vector = -1;
    private int zp_base = -1;
    private int sid_base = -1;
    private SidImage sid = null;
    private int song_addr = -1;
    private int hwid_addr = -1;
    private int title_addr;
    private int author_addr;
    private int year_addr;

    public void load(String prg_file_name, String label_file_name) {
        this.loadProgram(prg_file_name);
        this.loadSymbols(label_file_name);
    }

    private void loadSymbols(String label_file_name) {
        try {
            FileInputStream lbl_file = new FileInputStream(label_file_name);
            try {
                SymbolTable symbols = new SymbolTable();
                symbols.load(lbl_file, label_file_name);
                this.init_vector = symbols.findLabel("initadr");
                this.exec_vector = symbols.findLabel("execadr");
                this.zp_base = symbols.findLabel("zpuser");
                this.sid_base = symbols.findLabel("SIDIMAGE");
                this.song_addr = symbols.findLabel("song");
                this.hwid_addr = symbols.findLabel("hwid");
                this.title_addr = symbols.findLabel("title");
                this.author_addr = symbols.findLabel("author");
                this.year_addr = symbols.findLabel("copyright");
            }
            finally {
                try {
                    lbl_file.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e) {
            this.init_vector = -1;
            this.exec_vector = -1;
        }
    }

    private void loadProgram(String prg_file_name) {
        FileInfo prg_info = FileHelper.getFileInfo(prg_file_name, 2);
        this.start_address = prg_info.getStartAddress();
        this.prg_data = new byte[prg_info.getBlockSize()];
        prg_info.getLoadStrategy().loadToMemory(prg_file_name, new ByteArrayWrapper(this.prg_data), 0, prg_info.getBlockSize());
    }

    public void setSid(SidProcessor sid_processor) {
        this.sid = sid_processor.getSidAt(this.start_address + this.prg_data.length, this.zp_base, this.sid_base, this.hwid_addr);
    }

    public void write(String prg_file_name, int song) {
        FileInfo prg_info = FileHelper.getFileInfo(prg_file_name, 2);
        MemoryBlock memory = new MemoryBlock(65536);
        int i = 0;
        while (i < this.prg_data.length) {
            memory.getData()[i + this.start_address] = this.prg_data[i];
            ++i;
        }
        i = 0;
        while (i < this.sid.getData().length) {
            memory.getData()[i + this.sid.getStartAddress()] = this.sid.getData()[i];
            ++i;
        }
        this.putByte(memory, this.getSongAddr(), song);
        this.putWord(memory, this.init_vector, this.sid.getInitAddress());
        this.putWord(memory, this.exec_vector, this.sid.getExecAddress());
        this.putString(memory, this.title_addr, this.sid.getTitle(), 22);
        this.putString(memory, this.author_addr, this.sid.getAuthor(), 22);
        this.putString(memory, this.year_addr, this.sid.getYear(), 22);
        int end_address = this.sid.getStartAddress() + this.sid.getBlockSize();
        prg_info.getSaveStrategy().saveFromMemory(prg_file_name, memory, this.start_address, end_address - this.start_address);
    }

    private void putString(MemoryBlock memory, int address, String text, int len_max) {
        if (text != null) {
            String txpet = text.toUpperCase();
            int len = txpet.length();
            if (len > len_max) {
                len = len_max;
            }
            int i = 0;
            while (i < txpet.length()) {
                memory.getData()[address + i] = (byte)txpet.charAt(i);
                ++i;
            }
        }
    }

    private void putWord(MemoryBlock memory, int address, int word) {
        memory.getData()[address] = (byte)(word & 0xFF);
        memory.getData()[address + 1] = (byte)(word >> 8 & 0xFF);
    }

    private void putByte(MemoryBlock memory, int address, int byt) {
        memory.getData()[address] = (byte)(byt & 0xFF);
    }

    public int getSongAddr() {
        return this.song_addr;
    }
}

